#include <OpenDoor.h>
#include "ctype.h"
#include "stdlib.h"
#include "time.h"

#define BOARD_WIDTH 40
#define BOARD_HEIGHT 20
#define BOT_COUNT 10

char board[BOARD_HEIGHT][BOARD_WIDTH];
int posX, posY;
int robotX[BOT_COUNT];
int robotY[BOT_COUNT];
int robotCount;

void displayStatus(char *text) {
	od_set_cursor(22, 5);
	od_clr_line();
	od_printf("`bright white`%s", text);
}

void drawBoard() {
	int i;
	int j;
	
	for (i=0;i<BOARD_HEIGHT;i++) {
		for(j=0;j<BOARD_WIDTH;j++) {
			od_set_cursor(i + 1, j + 5);
			switch(board[i][j]) {
				case 'X':
					od_printf("`bright cyan`X");
					break;
				case '*':
					od_printf("`bright green`*");
					break;
				case '+':
					od_printf("`bright yellow`+");
					break;
				case ' ':
					od_printf("`white` ");
					break;
			}
		}
	}
}

void setupBoard() {
	int i;
	int j;
	
	robotCount = BOT_COUNT;
	
	for (i=0;i<BOARD_HEIGHT;i++) {
		for (j=0;j<BOARD_WIDTH;j++) {
			if (rand() % 20 == 5) {
				board[i][j] = 'X';
			} else {
				board[i][j] = ' ';
			}
		}
	}
	
	for (i=0;i<BOARD_HEIGHT;i++) {
		board[i][0] = 'X';
		board[i][BOARD_WIDTH-1] = 'X';
	}
	for (i=0;i<BOARD_WIDTH;i++) {
		board[0][i] = 'X';
		board[BOARD_HEIGHT-1][i] = 'X';
	}
	
	// add player
	
	do {
		posX = rand() % (BOARD_WIDTH - 2) + 1;
		posY = rand() % (BOARD_HEIGHT - 2) + 1;
	} while (board[posY][posX] == 'X');
	
	board[posY][posX] = '*';
	
	// add robots
	
	for (i=0;i<BOT_COUNT;i++) {
		do {
			robotX[i] = rand() %  (BOARD_WIDTH - 2)  + 1;
			robotY[i] = rand() %  (BOARD_HEIGHT - 2)  + 1;
		} while (board[robotY[i]][robotX[i]] != ' ');
		
		board[robotY[i]][robotX[i]] = '+';
	}
}

int robotMove() {
	int i;
	int j;
	
	int newX;
	int newY;
	
	for (i=0;i<BOT_COUNT;i++) {
		if (robotX[i] == -1 && robotY[i] == -1) continue;
		if (robotX[i] - posX > 0) {
			newX = robotX[i]-1;
		} else if (robotX[i] - posX < 0) {
			newX = robotX[i]+ 1;
		} else {
			newX = robotX[i];
		}
		
		if (robotY[i] - posY > 0) {
			newY = robotY[i]-1;
		} else if (robotY[i] - posY < 0) {
			newY = robotY[i]+ 1;
		} else {
			newY = robotY[i];
		}
		
		if (board[newY][newX] == 'X') {
			robotCount--;
			od_set_cursor(robotY[i] + 1, robotX[i] + 5);
			od_printf("`white` ");
			board[robotY[i]][robotX[i]] = ' ';
			robotY[i] = -1;
			robotX[i] = -1;
		} else if (board[newY][newX] == '+') {
			// destroy both robots;
			for (j=0;j<BOT_COUNT;j++) {
				if (robotX[j] == newX && robotY[j] == newY) {
					robotX[j] = -1;
					robotY[j] = -1;
				}
			}
			od_set_cursor(robotY[i] + 1, robotX[i] + 5);
			od_printf("`white` ");
			board[robotY[i]][robotX[i]] = ' ';
			robotX[i] = -1;
			robotY[i] = -1;
			robotCount -= 2;
			board[newY][newX] = ' ';
			od_set_cursor(newY + 1, newX + 5);
			od_printf("`white` ");
			
		} else if (board[newY][newX] == '*') {
			// uh oh
			od_set_cursor(robotY[i] + 1, robotX[i] + 5);
			od_printf("`white` ");			
			od_set_cursor(newY + 1, newX + 5);
			od_printf("`bright red`+");			
			displayStatus("Executed by a Robot! You're Dead. Press a key to Exit");
			return 1;
		} else {
			board[robotY[i]][robotX[i]] = ' ';
			board[newY][newX] = '+';
			od_set_cursor(robotY[i] + 1, robotX[i] + 5);
			od_printf("`white` ");
			od_set_cursor(newY + 1, newX + 5);
			od_printf("`bright yellow`+");
			
			robotY[i] = newY;
			robotX[i] = newX;
		}
	}
	if (robotCount == 0) {
		displayStatus("You win! Press a key to Exit");
		return 1;
	}
	return 0;
}

int playerMove() {
	char key = od_get_answer("789461230JjQq");
	int newX;
	int newY;
	

	
	switch (tolower(key)) {
		case '7':
			newX = posX - 1;
			newY = posY - 1;
			break;
		case '8':
			newY = posY - 1;
			newX = posX;
			break;
		case '9':
			newY = posY - 1;
			newX = posX + 1;
			break;
		case '4':
			newX = posX - 1;
			newY = posY;
			break;
		case '6':
			newX = posX + 1;
			newY = posY;
			break;
		case '1':
			newX = posX - 1;
			newY = posY + 1;
			break;
		case '2':
			newY = posY + 1;
			newX = posX;
			break;
		case '3':
			newY = posY + 1;
			newX = posX + 1;
			break;
		case '0':
			return 0;
		case 'j':
			newX = rand() % (BOARD_WIDTH -2) + 1;
			newY = rand() % (BOARD_HEIGHT -2) + 1;
			break;
		case 'q':
			od_exit(0, FALSE);
			break;
	}
	
	if (board[newY][newX] == ' ') {
		// safe move
		board[newY][newX] = '*';
		board[posY][posX] = ' ';
		od_set_cursor(posY + 1, posX + 5);
		od_printf("`white` ");
		od_set_cursor(newY + 1, newX + 5);
		od_printf("`bright green`*");
		posY = newY;
		posX = newX;
		return 0;
	}
	else {
		if (board[newY][newX] == 'X') {
			// electrocuted
			displayStatus("High Voltage! ZAPP!! You're Dead. Press a key to Exit");
		} else {
			// robot got you!
			displayStatus("Executed by a Robot! You're Dead. Press a key to Exit");
		}
		return 1;
	}	
}

#if defined(WIN32) || defined(_MSC_VER)
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,LPSTR lpszCmdLine,int nCmdShow)
{
#else
int main(int argc, char **argv)
{
#endif
	time_t seed = time(NULL);
	int done = 0;
	int quit = 0;
	srand(seed);

#if defined WIN32
	od_parse_cmd_line(lpszCmdLine);
#else
	od_parse_cmd_line(argc, argv);
#endif
	od_init();
	
	while (!quit) {
		od_clr_scr();
		od_send_file("intro.ans");
		
		switch(tolower(od_get_answer("PpQq"))) {
			case 'p':
				done = 0;
				od_clr_scr();
				setupBoard();
				od_send_file("board.ans");
				drawBoard();
				while (!done) {
					od_set_cursor(23, 79);
					if (playerMove()) break;
					done = robotMove();
				}
				od_get_key(TRUE);
				break;
			case 'q':
				quit = 1;
				break;
		}
	}
	od_exit(0, FALSE);
}
