PROGRAM QkTerm;

USES
Dos, OpDos, OpCrt, ApAnsi, ApMisc, ApPort, ApUart, OoCom;

{
          Modified 10/16/91
          Uses Async Professional Only!
}

CONST
  ACK = #06;
  NAK = #15;
  ESC = #27;
  MNREV = #254;      {MultiNode Scrabble Identifier}
  SGREV = #255;      {Single Node Scrabble Identifier}

VAR
  aUP                               : UartPort;
  ComName                           : ComNameType;
  Done, Graphics, MultiNode         : Boolean;
  Baud                              : longint;
  Value                             : integer;
  sPort, sBaud                      : string;
  ch                                : char;

  PROCEDURE ShowScreen(ScreenData : Pointer);
  VAR
    ScreenSegment : Word;
  BEGIN
    IF Graphics THEN
      ScreenSegment := $B800
    ELSE
      ScreenSegment := $B000;
    Move(ScreenData^, Ptr(ScreenSegment, 0)^, 4000);
  END;

  PROCEDURE ExitQkTerm;
  BEGIN
    aUP.Done;
    Halt;
  END;

  PROCEDURE OpenScreenColor; EXTERNAL;
  {$L OpenCol}
  PROCEDURE OpenScreenMono; EXTERNAL;
  {$L OpenMon}
  PROCEDURE GameBoardColor; EXTERNAL;
  {$L Color}
  PROCEDURE MNBoardColor; EXTERNAL;
  {$L ColorMN}
  PROCEDURE GameBoardMono; EXTERNAL;
  {$L Mono}
  PROCEDURE MNBoardMono; EXTERNAL;
  {$L MonoMN}

PROCEDURE ShowCopyright;
BEGIN
  clrscr;
  Writeln('QkTerm III  Copyright (c) 1991 Christopher Hall');
  Writeln;
  Writeln('                   Christopher Hall');
  Writeln('                   P.O. Box 26025');
  Writeln('                   Austin, Tx   78755');
  Writeln('                   Fido 1:382/29.4');
  Writeln;
END;

BEGIN
  Graphics  := (Lo(LastMode) <> 7);
  MultiNode := False;
  IF ParamCount < 2 THEN
  BEGIN
    ShowCopyright;
    WriteLn('Syntax:  QkTerm Port# Baud_Rate [Use CTS?]');
    WriteLn('eg.      QkTerm 1 2400     - Specify Port Params w/ NO CTS HandShaking');
    WriteLn('         QkTerm 1 38400 Y  - Specify Port Params Use CTS HandShaking');
    Halt;
  END;
  sPort := ParamStr(1);
  Value := Ord(sPort[1]) - Ord('1');
  ComName := ComNameType(Value);
  sBaud := ParamStr(2);
  CASE sBaud[1] OF
    '1': IF sBaud[2] = '9' THEN
           Baud := 19200
         ELSE
           Baud := 1200;
    '2': Baud := 2400;
    '3': IF sBaud[2] = '0' THEN
           Baud := 300
         ELSE
           Baud := 38400;
    '4': Baud := 4800;
    '9': Baud := 9600;
    else Baud := 2400;
  END;
  if NOT aUP.InitCustom(ComName, Baud, NoParity, 8, 1, 2000, 2000, ptRestoreOnClose+ptRaiseModemOnOpen) then
  begin
    writeln('Unable to initialize Comm Port: ', AsyncStatus);
    Halt;
  end;
  if ClassifyUart(aUP.GetBaseAddr, True) = U16550A then
  begin
    SetFifoBuffering(aUP.GetBaseAddr, False, 1);
    SetFifoBuffering(aUP.GetBaseAddr, True, 8);
  end;
  if ParamCount > 2 then
    aUP.HWFlowEnable(1800,200,hfUseRTS+hfRequireCTS);
  aUP.SetDTR(True);
  clrscr;
  WriteLn('QkTerm is Activated!  Press <ESC> any time to Abort!');
  Done := False;
  if aUP.CheckDCD then
    aUP.PutChar(ACK);      {Send an ACK for Auto-Checking of Qkterm}
  REPEAT
    IF KeyPressed THEN
    BEGIN
      ch := ReadKey;
      IF ch = ESC THEN ExitQkTerm;
      IF ch = #0 THEN
      BEGIN
        ch := ReadKey;
        CASE ch OF
          ESC, #45 : ExitQkTerm;       {Esc or Alt-X to Exit}
          #46      : ClrScr;           {Alt-C to Clear Screen}
        END; {CASE}
      END
      ELSE
      BEGIN
        while NOT aUP.TransReady DO;
        aUP.PutChar(ch);
      END;
    END;

    IF aUP.CharReady THEN
    BEGIN
      aUP.GetChar(ch);
      if ch <> ESC then WriteCharAnsi(ch)
      ELSE
      BEGIN
        while NOT aUP.CharReady do;
        aUP.GetChar(ch);
        CASE ch OF
          MNREV : BEGIN
                    MultiNode := True;
                    aUP.PutChar(ACK);
                  END;
          SGREV : aUP.PutChar(ACK);
          '@'   : IF Graphics THEN
                  BEGIN
                    IF MultiNode THEN
                      ShowScreen(@MNBoardColor)
                    ELSE
                      ShowScreen(@GameBoardColor);
                  END
                  ELSE
                  BEGIN
                    IF MultiNode THEN
                      ShowScreen(@MNBoardMono)
                    ELSE
                      ShowScreen(@GameBoardMono);
                  END;
          '*'   : IF Graphics THEN
                    ShowScreen(@OpenScreenColor)
                  ELSE
                    ShowScreen(@OpenScreenMono);
          '!' : Done := True;
          ELSE
          BEGIN
            WriteCharAnsi(ESC);         {stuff ESC back in}
            WriteCharAnsi(ch);          {process the ANSI sequence}
          END;
        END; {CASE}
      END;
    END;
  UNTIL Done;
  ShowCopyright;
  ExitQkTerm;
END.
