#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>
#include <conio.h>


/* COFFSET is the size of the config file. This one must be changed if you change CONFIG */
#define COFFSET 264


typedef struct config {
    char  stpath[130]; /* path to starfighter */
    char  gtnpath[130]; /* path to guess the number */
    long int jackpot; /* current jackpot for the guess the number game */
 /* char  sysopname[21];     These are some variables that you may wish to
    char  bbsname[21];       use in your games. You can use as many as you
    char  registercode[21];  need. */
} CONFIG;


void mainmenu(void);
void mainmenuoption(void);
void printcolor(char *colorstring);
void configfind(void);
void configread(void);
void configmenu(void);
void configmenuoption(void);
void configedit(void);
void configsave(void);
void configcreate(void);
void makewindow(int left,int top,int right,int bottom,int backcolor,int forecolor);
void setcolor(int backcolor,int forecolor);
void pressakey(void);
int  getintstring(int num);
long int getlongstring(int num);
char *getcharstring(int num);
char getyesorno(void);
void printyesorno(char value);
void install(void);
void uninstall(void);


/* GLOBAL VARIABLES */
CONFIG config;
CONFIG dummy;  /* The above, for some reason, will not work without this. You
		  may not need it. It is really useless. */
CONFIG *cptr = &config;


void main(void) {

     configfind();
     makewindow(1,1,80,25,0,7);

} /* end of main */

void mainmenu(void)
{

       makewindow(1,1,80,25,0,1);
       gotoxy(1,5);
       printcolor("   ^PAMain Menu#"
		  "^JA----------------#"
		  "(^FAC^JA)onfigure Game#"
		  "(^FAI^JA)nstall Game#"
		  "(^FAU^JA)ninstall Game#"
		  "(^FAQ^JA)uit##"
		  "(^FAC^JA,^FAI^JA,^FAU^JA,^FAQ^JA)=>");

} /* end of mainmenu() */

void mainmenuoption(void) {

    char option;

       mainmenu();
       do {
	 option = toupper(getch());
	 switch (option) {
	   case 'C': configmenuoption(); mainmenu(); break;
	   case 'I': install(); mainmenu(); break;
	   case 'U': uninstall(); mainmenu(); } /* end of switch */
	} while (option != 'Q');

}  /* end of mainmenuoption */

void install(void) {

   char filefound = 0;
   char found = 0;
   char number = 0;
   char line[81];
   FILE *fptr;

     clrscr();

     if((fptr = fopen(config.stpath,"r")) != NULL) {
	filefound = 1;
	fgets(line,81,fptr);
	while((!feof(fptr)) && (number < 9) && (!found)) {
	  if(strncmp(line,"Guess The Number",16) == 0)
	    found = 1;
	  number++;
	  fgets(line,81,fptr);
	  fgets(line,81,fptr); } /* end of while */ } /* end of if*/
     else
	printcolor("^EACannot find file GAMES.DAT! Check the path.");

     fclose(fptr);

     if(number == 9)
       printcolor("^EAGAMES.DAT is full! You need to uninstall a game to install this one!");
     else if(found)
       printcolor("^EAGuess The Number is already installed to GAMES.DAT!");
     else if(filefound) {
       printcolor("^KAInstalling Guess The Number to GAMES.DAT...");
       fptr = fopen(config.stpath,"a");
       fputs("Guess The Number\nguess.bat\n",fptr);
       fclose(fptr);
       printcolor("Done!"); } /* end of else */

     pressakey();


} /* end of install() */

void uninstall(void) {

   char filefound = 0;
   char found = 0;
   char line[81];
   FILE *fptr,*temp;

     clrscr();

     if((fptr = fopen(config.stpath,"r")) != NULL) {
	filefound = 1;
	temp = fopen("tempfile.dat","w");
	fgets(line,81,fptr);
	while(!feof(fptr)) {
	  if(strncmp(line,"Guess The Number",16) == 0) {
	    found = 1;
	    fgets(line,81,fptr); }
	  else {
	    fputs(line,temp);
	    fgets(line,81,fptr);
	    fputs(line,temp); }
	  fgets(line,81,fptr); } /* end of while */ } /* end of if*/
     else
	printcolor("^EACannot find file GAMES.DAT! Check the path.");

     fclose(fptr);
     fclose(temp);

     if((filefound) && (!found))
       printcolor("^EAGuess The Number was not installed to GAMES.DAT!");
     else if(filefound)
       printcolor("^KAGuess The Number has been removed from GAMES.DAT.");

     remove(config.stpath);
     rename("tempfile.dat",config.stpath);

     pressakey();



} /* end of uninstall() */

char getyesorno(void) {

   char option, value;

       do {
	  switch(option = toupper(getch())) {
	     case 'Y': value = 1; break;
	     case 'N': value = 0; break; }
	} while((option != 'Y')&&(option != 'N'));

       return(value);

} /* end of getyesorno() */

void pressakey(void) {

     printcolor("##^BA(^PAPress a Key^BA)");
     getch();

 } /* end of pressakey() */

void configread(void) {

   FILE *fptr;


     clrscr();
     fptr = fopen("gtncfg.dat","rb");
     fread(cptr,COFFSET,1,fptr);
     fclose(fptr);

} /* end of configread() */

void configmenu(void) {

   makewindow(1,1,80,21,0,14);
   printcolor(" ^PA1. ^KAPath To StarFighter!     :");
   printf("\n%s",config.stpath);
   gotoxy(1,4);
   printcolor(" ^PA2. ^KAPath To Guess The Number :");
   printf("\n%s",config.gtnpath);
   gotoxy(1,7);
   printcolor(" ^PA3. ^KAJackpot                  :");
   printf("\n%ld",config.jackpot);

   makewindow(1,22,80,25,7,15);
   printcolor(" ^EHE^AHdit  ^EHS^AHave  ^EHQ^AHuit#");

} /* end of configmenu() */

void configmenuoption(void) {

  char option;


     configmenu();
     do {
       switch (option = toupper(getch())) {
	 case 'E': configedit(); configmenu(); break;
	 case 'S': configsave(); break;
	 case 'Q': configread(); } /* end of switch */
     } while (option != 'Q');

} /* end of configmenuoption() */

void configedit(void) {

   char *dummy;


	 setcolor(7,1);
	 printcolor("^BH Enter your choice to edit (1 - 3). ");
	 switch (getintstring(2)) {
	   case 1:  printcolor("# Enter the path to StarFighter!.");
		    makewindow(1,2,80,3,1,15);
		    dummy = getcharstring(128);
		    strncpy(config.stpath,dummy,128);
		    if((strstr(config.stpath,"\\games.dat")) == NULL)
		      strcat(config.stpath,"\\games.dat"); break;
	   case 2:  printcolor("# Enter the path to Guess The Number.");
		    makewindow(1,5,80,6,1,15);
		    dummy = getcharstring(128);
		    strncpy(config.gtnpath,dummy,128);
		    if((strstr(config.gtnpath,"\\guess.bat")) == NULL)
		      strcat(config.gtnpath,"\\guess.bat"); break;
	   case 3:  printcolor("# Enter amount for the jackpot (5,000 - 2,000,000,000).");
		    makewindow(1,8,10,8,1,15);
		    config.jackpot = getlongstring(10);
		      if((config.jackpot < 5000) || (config.jackpot > 2000000000))
			 config.jackpot = 5000; } /* end of switch */


} /* end of configedit() */

void configsave(void) {

   FILE *fptr;

     fptr = fopen("gtncfg.dat","wb");
     fwrite(cptr,COFFSET,1,fptr);
     fclose(fptr);

} /* end of configsave() */

void configfind(void) {

   FILE *fptr;

   if((fptr = fopen("gtncfg.dat","rb")) != NULL) {
       fclose(fptr);
       configread();
       mainmenuoption(); }
   else {
       clrscr();
       printcolor("^EA*******^PAWARNING^EA*******#"
		  "^PAFile ^OAgtncfg.dat ^PAdoes not exist!#"
		  "Would you like to create it (^OAy^PA/^OAn^PA)? ");
       configcreate();
      }

} /* end of configfind */

void configcreate(void) {

    char option;

      do {
	switch (option = toupper(getch())) {
	 case 'Y': printcolor("###Creating file ^OAgtncfg.dat.");
		   printcolor("#^PAInitializing file ^OAgtncfg.dat.");
		   config.stpath[0] = ' ';
		   config.gtnpath[0] = ' ';
		   config.jackpot = 5000;
		   configsave();
		   printcolor("#^PAFile ^OAgtncfg.dat ^PAnow exists.  You can now edit the file");
		   printcolor("##(Press a Key)");
		   getch();
		   mainmenuoption(); break;
	 case 'N': printcolor("###^EASorry, but you can not use this editor"
			      " or play ^PAGuess The Number#^EAwithout the file "
			      "^OAgtncfg.dat");
		   printcolor("#^EAOh well, maybe next time.##(Press a Key)");
		   getch(); } /* end of switch */
      } while((option != 'Y') && (option != 'N'));

}  /* end of configcreate() */

int getintstring(int num) {

    char cell;
    char *intstring;
    int i, number, finished, x, y;


	 finished = i = 0;
	 do {
	   cell = getch();
	   if((isdigit(cell))&&(i < num)) {
	      putch(cell);
	      intstring[i] = cell;
	      i++; } /* end of if */
	   else if(cell == 13)
	      finished = 1;
	   else if((cell == 8)&&(i>0)) {
	      i--;
	      intstring[i] = 0;
	      x = wherex(); y = wherey();
	      gotoxy(x - 1,y);
	      putch(' ');
	      gotoxy(x - 1,y); } /* end of else if */
	 } while(!finished);

	 number = atoi(intstring);
	 for(i=0;i<num;i++)
	    intstring[i] = 0;
	 return(number);

} /* end of getintstring */

long int getlongstring(int num) {

    char cell;
    char *intstring;
    int i, finished, x, y;
    long int number;


	 finished = i = 0;
	 do {
	   cell = getch();
	   if((isdigit(cell))&&(i < num)) {
	      putch(cell);
	      intstring[i] = cell;
	      i++; } /* end of if */
	   else if(cell == 13)
	      finished = 1;
	   else if((cell == 8)&&(i>0)) {
	      i--;
	      intstring[i] = 0;
	      x = wherex(); y = wherey();
	      gotoxy(x - 1,y);
	      putch(' ');
	      gotoxy(x - 1,y); } /* end of else if */
	 } while(!finished);

	 number = atol(intstring);
	 for(i=0;i<num;i++)
	    intstring[i] = 0;
	 return(number);

} /* end of getlongstring */

char *getcharstring(int num) {

    char cell;
    char *charstring;
    int i, finished, x, y;


	 for(i=0;i<num;i++)
	    charstring[i] = 0;

	 finished = i = 0;
	 do {
	   cell = getch();
	   if((isprint(cell))&&(i < num)) {
	      putch(cell);
	      charstring[i] = cell;
	      i++; } /* end of if */
	   else if(cell == 13)
	      finished = 1;
	   else if((cell == 8)&&(i>0)) {
	      i--;
	      charstring[i] = 0;
	      x = wherex(); y = wherey();
	      gotoxy(x - 1,y);
	      putch(' ');
	      gotoxy(x - 1,y); } /* end of else if */
	 } while(!finished);

	 return(charstring);

} /* end of getcharstring */

void makewindow(int left,int top,int right,int bottom,int backcolor,int forecolor) {

   window(left,top,right,bottom);
   setcolor(backcolor,forecolor);
   clrscr();

} /* end of makewindow() */

void setcolor(int backcolor,int forecolor) {

    textbackground(backcolor);
    textcolor(forecolor);

} /* end of setcolor() */

void printcolor(char *colorstring) {

    int i, length;


       length = strlen(colorstring);
       for(i = 0;i < length;i += 1) {
	  if (colorstring[i] == '^')
	    setcolor(colorstring[i += 1] - 65,colorstring[i += 1] - 65);
	  else if (colorstring[i] == '#')
	    printf("\n");
	  else
	    putch(colorstring[i]);
       } /* end for */

} /* end printcolor */

