#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>
#include <share.h>
#include "c:\tridoor\tdoor.h"


/* OFFSET is the size of the player record */
#define OFFSET 148
/* EOFFSET is the size of the enemy record */
#define EOFFSET 85
/* WOFFSET  is the size of the weapon record and the shield record */
#define WOFFSET 29
/* COFFSET is the size of the config file. This one must be changed if you change CONFIG */
#define COFFSET 264


typedef struct config {
    char  stpath[130]; /* path to starfighter */
    char  gtnpath[130]; /* path to guess the number */
    long int jackpot; /* current jackpot for the guess the number game */
 /* char  sysopname[21];     These are some variables that you may wish to
    char  bbsname[21];       use in your games. You can use as many as you
    char  registercode[21];  need. */
} CONFIG;


typedef struct player {
    char      name[21];   /* user's real name */
    char      alias[21];  /* user's name on StarFighter! */
    long int  expoints;   /* number of experience points */
    int       playerfights; /* fights left against other players */
    int       spacefights;  /* fights (or turns) left in space */
    int       maxshields;  /* maximum number of shields that player can have */
    int       shieldsleft;  /* the number of shields that player has left */
    int       weaponstrength;  /* total weapon strength - strength of ship and strength of weapon combined */
    long int  creditsonhand;  /* how many credits (cash) player has on hand */
    long int  creditsinbank;  /* how many credits player has in bank */
    char      shield; /* shield number */
    char      shieldname[21];  /* name of shield */
    char      weapon;  /* weapon number */
    char      weaponname[21];  /* name of weapon */
    int       playerwins;  /* how many times player has won a player vs. player battle */
    int       playerlosses;  /* how many times player has loss a player vs. player battle */
    int       accuracy;  /* accuracy of ships weapon (how often player hits opponent) */
    int       evasiveness;  /* evasiveness of ship (how often player dodges a hit) */
    int       shieldintegrity;  /* shield integrity (how many hit points shields absorb) */
    int       torpedos;  /* number of torpedos player has left */
    int       torpedosleft;  /* maximum number of torpedos player can use */
    int       ejections;  /* how many times player has ejected (been defeated) in space fightes */
    int       da_year; /* year, month, and day player was last on */
    char      da_mon;
    char      da_day;
    int       ontoday; /* 0 = player has been on today. Otherwise, keeps track of how many days player has NOT been on. */
    char      crystals; /* number of fuel crystals player has */
    char      rip[13]; /* not used yet. */
    /* these variables have been broken up into bits */
    unsigned int          level: 4;  /* player's current level (1 - 11) */
    unsigned int         gender: 1;  /* player's gender: 0 = male, 1 = female */
    unsigned int         status: 2;  /* player's status: 0 = READY, 1 = EJECTED, 2 = BEATEN */
    unsigned int    fightertype: 2;  /* player's fighter type: 0 = dual-gun, 1 = tri-gun, 2 = quad-gun, 3 = penta-gun */
    unsigned int   dualcomplete: 1;  /* 1 if player has finished the dual-gun missions, otherwise 0 */
    unsigned int    tricomplete: 1;  /* 1 if player has finished the tri-gun missions, otherwise 0 */
    unsigned int   quadcomplete: 1;  /* 1 if player has finished the quad-gun missions, otherwise 0 */
    unsigned int    seendweebli: 1;  /* 1 if player has seen dweebli today, otherwise 0 */
    unsigned int          drink: 1;  /* 1 if player has had a drink at Larry's today, otherwise 0 */
    unsigned int             on: 1;  /* 1 if player is currently on, 0 if not */
    unsigned int        secret1: 1;  /* 1 if secret has been accomplished today, otherwise 0 */
    /* these variables are not being used yet */
    unsigned int        secret2: 8;
    unsigned int        secret3: 1;
    unsigned int        secret4: 1;
    unsigned int        secret5: 1;
    unsigned int        secret6: 1;
    unsigned int        secret7: 1;
    unsigned int        secret8: 1;
    unsigned int        secret9: 1;
    unsigned int        secret10: 1;
  } PLAYER;

typedef struct enemy {
    char      name[21];  /* name of enemy */
    char      shipname[21];  /* name of enemy's ship */
    char      species[11];  /* species of enemy, ex: Raptoran, Martian, etc */
    char      gender; /* 0 = male, 1 = female, 2 = none or unknown */
    int       numberofweapons;  /* number of weapons that enemy's ship has */
    int       shields;  /* number of shields */
    int       accuracy;  /* enemy's accuracy */
    int       evasiveness;  /* enemy's evasiveness */
    int       weaponstrength;  /* enemy's weapon strength */
    int       shieldintegrity; /* enemy's shield integrity */
    int       experience;  /* experience points for defeating enemy */
    long int  credits;  /* amount of credits for defeating enemy */
    char      rip[13]; /* not used yet */
  } ENEMY;

typedef struct weapon {
    char name[21];  /* name of weapon */
    int weaponstrength;  /* amount it adds to player's weapon strength */
    int accuracy;  /* amount it adds to player's accuracy */
    long int cost;  /* cost of weapon */
 } WEAPON;

typedef struct shield {
    char name[21];  /* name of shield */
    int shieldintegrity;  /* amount it adds to player's shield integrity */
    int shields;  /* amount of shields it adds to player's shields */
    long int cost;  /* cost of shield */
 } SHIELD;


void configread(void);
void configsave(void);
int  readdropfile(void);
void getplayer(int recnum);
void saveplayer(int recnum);
void playgame(void);
void winnings(long int money);
void printcolor(char *colorstring);
void pressakey(void);
char getyesorno(void);
void displaywelcome(void);
void quitscreen(void);
void chopstring(char *str);



/* GLOBAL VARIABLES */
PLAYER player1;
PLAYER *pptr = &player1;
CONFIG config;
CONFIG *cptr = &config;
char   line[120];
int    recnum;
char   alias[21];
/*char   userame[81];       These variables are not necessary if you are
char   bbsname[81]          using TDOOR or another door library that support
char   sysopname[81]        these variables. (See in readdropfile())
long   baudrate;
long   lockedbaudrate;
int    minutesleft;
int    nonstandardirq;
int    serialport; */


void main(int argc, char *argv[]) {


    TDInitialize(argc,argv);
    strcpy(TDDoorName, "Guess The Number 1.0");
    randomize();

    if(readdropfile()) {
      displaywelcome();
      configread();
      getplayer(recnum);
      playgame();
      configsave();
      saveplayer(recnum);
      quitscreen(); } /* end of if */
    else {
      TDClrScr();
      printcolor("^EDROPFILE.DAT is missing.  Please tell your sysop.");
      pressakey(); } /* end of else */

} /* end of main() */


int readdropfile(void) {

  FILE *dropfile;
  int  found = 1;
  char rec[4];


      if((dropfile = fopen("dropfile.dat","r")) != NULL) {
	found = 1;
	fgets(rec,4,dropfile);
	recnum = atoi(rec);
	fgets(TDUserName,81,dropfile);  /* or username */
	chopstring(TDUserName);
	fgets(alias,21,dropfile);
	fgets(TDBBSName,81,dropfile);   /* or bbsname */
	chopstring(TDBBSName);
	fgets(TDSysopName,81,dropfile); /* or sysopname */
	fgets(line,81,dropfile);
	TDBaudRate = atol(line);        /* or baudrate */
	fgets(line,81,dropfile);
	TDLockedBaudRate = atol(line);  /* or lockedbaudrate */
	fgets(line,81,dropfile);
	TDMinutesLeft = atoi(line);     /* or minutesleft */
	fgets(line,81,dropfile);
	TDNonStandardIRQ = atoi(line);  /* or nonstandardirq */
	fgets(line,81,dropfile);
	TDSerialPort = atoi(line);      /* or serialport */
       } /* end of if */

     fclose(dropfile);
     return(found);

} /* end of readdropfile() */


void configsave(void) {

   FILE *fptr;
   CONFIG *ptr = &config;

     fptr = fopen("gtncfg.dat","wb");
     fwrite(ptr,COFFSET,1,fptr);
     fclose(fptr);

} /* end of configsave() */

void configread(void) {

   FILE *fptr;
   CONFIG *ptr = &config;


     clrscr();
     fptr = fopen("gtncfg.dat","rb");
     fread(ptr,COFFSET,1,fptr);
     fclose(fptr);

} /* end of configread() */


void chopstring(char *str) {

  int length;

     length = strlen(str);
     str[length - 1] = '\0';

} /* end of chopstring */

void getplayer(int recnum) {


     FILE *fptr;

       fptr = _fsopen("players.dat","rb",SH_DENYWR);
       fseek(fptr,(recnum * OFFSET),SEEK_SET);
       fread(pptr,OFFSET,1,fptr);
       fclose(fptr);

}  /* end of getplayer */

void saveplayer(int recnum) {

    FILE *fptr;

      fptr = _fsopen("players.dat","r+b",SH_DENYNONE);
      fseek(fptr,(long) (recnum * OFFSET),SEEK_SET);
      fwrite(pptr,OFFSET,1,fptr);
      fclose(fptr);

} /* end of saveplayer */

void displaywelcome(void) {

	TDClrScr();
	printcolor("^P@a\n^OWritten By ^PDon Donnelly\n");
	printcolor("^OCompiled ^P2/12/96 ^Ousing ^GTurbo C ^Oand\n");
	printcolor("^GTDoor ^Oby ^PMark Goodwin^O.\n\n");
	printcolor("^OThis is ^KFREEWARE!\n");
	printcolor("\n^PPress A Key");
	TDGetch();

} /* end of displaywelcome() */

void quitscreen(void) {

       TDClrScr();
       printcolor("^DThanks ^K@d ^Dfor playing ^P@a^D!");
       sprintf(line,"\n\nReturning to ^PStarFighter!^D...\n");
       printcolor(line);
       exit(0);

} /* end of quitscreen() */

void playgame(void) {
/* This game originally came as a test game with the TDOOR library. It was
   originally written by Mark Goodson and has been edited by Don Donnelly */

  int computernum, usernum, win, numguesses, input;
  long int money;


	TDClrScr();
	if (config.jackpot < 5000)
	   config.jackpot = 5000;


	printcolor("\n^K   Guess The Number");
	printcolor("\n^F~~~~~~~~~~~~~~~~~~~~~~");
	printcolor("\n^DYou walk up to the ^LGuess the Number^D machine. You read the game menu.");
	printcolor("\nThe object of this game is to try to guess the number in as few tries as");
	printcolor("\npossible.  The payoffs are:");

	printcolor("\n\n^P1 ^Dguess   = ^PTHE JACK POT");
	printcolor("\n^P2 ^Dguesses = ^P4:1");
	printcolor("\n^P3 ^Dguesses = ^P3:1");
	printcolor("\n^P4 ^Dguesses = ^P2:1");
	printcolor("\n^P5 ^Dguesses = ^P1:1^D");

	printcolor("\n\n(^FP^D)lay Game");
	printcolor("\n(^FQ^D)uit");
	printcolor("\n\n(^FP^D,^FQ^D)=>");

	do {
	   input = toupper(TDGetch());
	} while (input != 'P' && input != 'Q');
	if (input == 'P') {
	 do {
	   do {
	       sprintf(line,"\n\n^OThe jackpot is ^P%ld ^Ocredits!",config.jackpot);
	       printcolor(line);
	       printcolor("\n^DHow many credits would you like to wager(1-1000, 0 to quit)?\n");
	       money = atol(TDGets(line,10));
	       if (money > player1.creditsonhand)
		  printcolor("^MYou do not have that many credits!\n");
	       else if (money < 0 || money > 1000)
		  printcolor("^MYour bet must be between 1 and 1000!\n");
	   } while ((money > player1.creditsonhand) || (money < 0) || (money > 1000));
	   if(money != 0) {
	    config.jackpot += money;
	    player1.creditsonhand -= money;
	    computernum = random(100) + 1;
	    win = 0;
	    numguesses = 0;
	    printcolor("^DThe computer is thinking of a number from ^P1-100^D.\n");
	    do {
	     numguesses++;
	     do {
		printcolor("^DEnter a number from ^P1-100^D.\n");
		TDGets(line,4);
		usernum = atoi(line);
		if (usernum < 1 || usernum > 100)
		   printcolor("^MNumber must be between ^P1-100^M!!\n");
	       } while (usernum < 1 || usernum > 100);
	      if (computernum == usernum)
		 win = 1;
	      else if (usernum > computernum)
		  printcolor("^MToo high!\n");
	      else
		  printcolor("^MToo low!\n");
	 } while (!win);

	   sprintf(line,"^OYou got it in ^P%d ^Oguesses!\n", numguesses);
	   printcolor(line);
	   switch (numguesses) {
	    case 5: winnings(money); break;
	    case 4: winnings(2 * money); break;
	    case 3: winnings(3 * money); break;
	    case 2: winnings(4 * money); break;
	    case 1: printcolor("^IOYou won the JACKPOT!!!\nYou won the JACKPOT!!!\n");
		    winnings(config.jackpot);
		    config.jackpot = 5000; break; } /* end of switch */
	   printcolor("Play again? (^Py^O/^Pn^O)\n\n");
	 do {
		input = toupper(TDGetch());
	} while (input != 'Y' && input != 'N'); } /* end of if */
      else
	input = 'N';
     } while (input != 'N');   } /* end of if */

} /* end of playgame() */

void winnings(long int money) {

    player1.creditsonhand += money;
    sprintf(line,"^OYou won ^P%ld ^Ocredits!\n",money);
    printcolor(line);

} /* end of winnings() */

char getyesorno(void) {

   char option;
   char value = 0;

      printcolor(" (y/n)=> ");
      do {
	 switch(option = toupper(TDGetch())) {
	    case 'Y': value = 1; printcolor("^KYes"); break;
	    case 'N': printcolor("^ENo"); }
      } while((option != 'Y')&&(option != 'N'));

      return(value);

} /* end of getyesorno() */

void pressakey(void) {

     printcolor("\n\n^PZap a Key, ^K@d");
     TDGetch();

} /* end of pressakey */

void printcolor(char *colorstring) {

    int i, length;


       length = strlen(colorstring);
       for(i = 0;i < length;i += 1) {
	  if (colorstring[i] == '^')
	    TDSetColor((colorstring[i += 1] - 65),0);
	  else if(colorstring[i] == '@')
	     switch(colorstring[++i]) {
	       case 'a': TDPrintf("%s",TDDoorName); break;
	       case 'd': printcolor(player1.alias); break;
	   /*  case 'e': TDPrintf("%s",enemy.name); break;
	       case 'f': printcolor(player.alias); break;  */
	       case '1': TDPrintf("\n"); }
	  else
	    TDPutch(colorstring[i]);
       } /* end for */

} /* end printcolor */
