//NOTE:  IF you made an IGM with the earlier versions of this, you must
//recompile it to be 16/32 bit like this example.  OR it aint' gonna work...
//The only thing that is changed is the main()
//////////////////////////////////////////////////////////////////////////
// MODULE.C: An example for a module run from one of stardock loco's expansion
// slots.  Feel free to use this code for any stardock loco modules.

// This was compiled using Borland Turbo C++ version 3.0
// This will _not_ compile without Brian Pirie's Opendoors odoorh.lib (huge model)

// Also feel free to upgrade my version of Guido's Black Market.
// Note: It is crucial to the game that they be able to upgrade their
// armor and weapon strength at the higher levels!  Make sure to keep that
// if you make a better black market.

/////////////////////////////////////////////////////////////////////////////
// Do not distribute any modules that use unregistered serial comm libraries!
/////////////////////////////////////////////////////////////////////////////

// Ok, enough of that, here's how I call this program.  This is the actual
// code that I use to spawn _from_ stardock loco for anyone that goes into the
// black market:    i.e. blkmkt1.exe
//
// Note:  This is nearly identical to, and works the same way from any expansion
// slots in the game.  The 'Yards expansion slots gets the filepath from
// the module.lst, and does the same thing as below.  The other slots
// are run by using _dos_find_first to find the first occurance of the first
// two letters.  See sd_devlp.txt for all the gruesome details.
//
// any od_control structure usage is from Brian Pirie's Opendoors 6.0 serial
// comm library.  Get his program and register it.
//
// od_control.od_force_local has a boolean value of 1 (TRUE) if the game
// has been set to run locally.
//
// od_control.info_path is the path to the door.sys, or whatever the file
// is that has the BBS information on the user.
//
//
//   Make sure it's there, or look for an upgrade to blkmkt2.exe etc.
//
//	if( _dos_findfirst("blkmkt?.exe",_A_NORMAL,&ffblk) ==0)
//		{
//		update_player_file();  //update the player file before spawn
//
//         32 bit or 16 bit platform running this?  Spawn accordingly
//
//		#ifdef ODPLAT_WIN32
//			od_spawnvpe(P_WAIT,filepath,lpszCmdLine,NULL);
//		#else
//			od_spawnvpe(P_WAIT,filepath,_argv,NULL);
//		#endif
//		check_it();       //make sure they aren't dead.
//                              - this is for real modules.
//                                A person can't die in the black market.
//		}
//////////////////////////////////////////////////////////////////////////
//
//                         Guido's Black Market
//                Formerly known as Indelgo's Black Market.
//////////////////////////////////////////////////////////////////////////
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <time.h>

#include "opendoor.h"
//from Brian Pirie's Opendoors 6.0 serial comm library
//contains all the functions and structures necessary for comm routines.

//Update, I've begun using 6.0.  New things shall arise.  See the web site:
//  http://www.starlink.com/~jam/stardock.shtml

#include <ctype.h>
#include <errno.h>

//see sd_devlp.txt for all the information on this stuff.
#define MAX 2
#define MAXNAME  30
#define	MAXBBSNAME 36
#define	MAXWEAPONNAME 20
#define	MAXARMORNAME 20
#define MAXSTANDARDLONG 10
#define MAXSTANDARDINT 4  //standard integer
#define WAIT_FOR_FILE         10       /* Time to wait for access to file */
FILE *OpenExclusiveFile(char *pszFileName, char *pszAccess, time_t Wait); //exclusive file access
void update_player_file(void);
void r_player_file(void);
void WaitForEnter(void);
void More(void);
void door(void);
void indelgos_bm(void);    //the module
void change(void);    //formats numbers to nice numbers with commas

struct on_line_player   //See the sd_devlp.txt for further explanations!!
	{
	int on_now;
	char name[MAXNAME+1];
	char bbs_name[MAXBBSNAME+1];
	int living;      //if alive = 1
	char killer[MAXNAME+1];     //who killed player
	int location;    //1 if in TP's, 2 if in pod
	long lifepoints;
	long lifepointsttl;

	char weapon[MAXWEAPONNAME+1];
	unsigned long weapon_energy;
	int weapon_strength;
	unsigned long max_packs;
	int weapon_status;
	unsigned long weapon_cost;

	char armor[MAXARMORNAME+1];
	unsigned long armor_strength;
	int armor_status;
	unsigned long armor_cost;

	unsigned long credits;
	unsigned long bank_credit;

	int pod;

	int ship;
	char ship_name[MAXNAME+1];
	int ship_type;
	int mt;              //matter transmitter
	int arkon_bomb;

	//*extra data:
	int level;
	unsigned long experience;
	int kills;
	int droids;
	int passkey;

   //assorted stuff *global* //
	int on_off;    //on off for off-line droid attack
	//reset daily by extern:   //from defaults....
	int sickbay_closed;        //killed staff
	int bank_closed;           //angered guido
	int pickpocket;            //picked N. Wetlys pocket
	int tipcnt;                //max tips taken
	int owns;                 //1 owns weapon shop, 2 owns armor shop
	int fights;                //fights per day 30?
	int last_played;           //stardock days running
	};

struct on_line_player current;

struct player
	{
	char on_now[MAXSTANDARDINT+1];
	char name[MAXNAME+1];
	char bbs_name[MAXBBSNAME+1];
	char living[MAXSTANDARDINT+1];      //if alive = 1
	char killer[MAXNAME+1];
	char location[MAXSTANDARDINT+1];
	char lifepoints[MAXSTANDARDLONG+1];
	char lifepointsttl[MAXSTANDARDLONG+1];

	char weapon[MAXWEAPONNAME+1];
	char weapon_energy[MAXSTANDARDLONG+1];
	char weapon_strength[MAXSTANDARDINT+1];
	char max_packs[MAXSTANDARDLONG+1];
	     //if they have a weapon = 1
	char weapon_status[MAXSTANDARDINT+1];
	char weapon_cost[MAXSTANDARDLONG+1];

	char armor[MAXARMORNAME+1];
	char armor_strength[MAXSTANDARDLONG+1];
	char armor_status[MAXSTANDARDINT+1];        //if they have armor = 1
	char armor_cost[MAXSTANDARDLONG+1];

	char credits[MAXSTANDARDLONG+1];
	char bank_credit[MAXSTANDARDLONG+1];

	char pod[MAXSTANDARDINT+1];

	char ship[MAXSTANDARDINT+1];
	char ship_name[MAXNAME+1];
	char ship_type[MAXSTANDARDINT+1];
	char mt[MAXSTANDARDINT+1];
	char arkon_bomb[MAXSTANDARDINT+1];

	char level[MAXSTANDARDINT+1];
	char experience[MAXSTANDARDLONG+1];
	char kills[MAXSTANDARDINT+1];
	char droids[MAXSTANDARDINT+1];
	char passkey[MAXSTANDARDINT+1];

     //globals
	char on_off[MAXSTANDARDINT+1];
	char sickbay_closed[MAXSTANDARDINT+1];
	char bank_closed[MAXSTANDARDINT+1];
	char pickpocket[MAXSTANDARDINT+1];
	char tipcnt[MAXSTANDARDINT+1];
	char owns[MAXSTANDARDINT+1];
	char fights[MAXSTANDARDINT+1];
	char last_played[MAXSTANDARDINT+1];
	};


int playerfound=0;
char door_sys_name[MAXBBSNAME+1];
int record_count;
char number[14];  //for formatted credit amounts and such.  See change();

//main()/WinMain() 32 bit is:
//Straight out of Brian Pirie's example, ez_vote.c from Opendoors 6.0
//This is his wording, coding, etc.  It works.  So I changed to his.

/* main() or WinMain() function - Program execution begins here. */
#ifdef ODPLAT_WIN32
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
   LPSTR lpszCmdLine, int nCmdShow)
#else
int main(int argc, char *argv[])
#endif
{

#ifdef ODPLAT_WIN32
   /* In Windows, pass in nCmdShow value to OpenDoors. */
   od_control.od_cmd_show = nCmdShow;

   /* Ignore unused parameters. */
   (void)hInstance;
   (void)hPrevInstance;
#endif


   /* Set program's name for use by OpenDoors. */

   //Change this for yours please...<G>!
   strcpy(od_control.od_prog_name, "Stardock Loco WIN95/NT - DOS 16bit");
   strcpy(od_control.od_prog_version, "Version 1 BETA");
   strcpy(od_control.od_prog_copyright, "Copyright 1995-1996 by Aaron Alanen");

   /* Call the standard command-line parsing function. You will probably     */
   /* want to do this in most programs that you write using OpenDoors, as it */
   /* automatically provides support for many standard command-line options  */
   /* that will make the use and setup of your program easer. For details,   */
   /* run the vote program with the /help command line option.               */
#ifdef ODPLAT_WIN32
   od_parse_cmd_line(lpszCmdLine);
#else
   od_parse_cmd_line(argc, argv);
#endif

   /* Enable use of OpenDoors configuration file system. */
   od_control.od_config_file = INCLUDE_CONFIG_FILE;

   /* Set function to process custom configuration file lines. */
   //od_control.od_config_function = CustomConfigFunction;

   /* Include the OpenDoors multiple personality system, which allows    */
   /* the system operator to set the sysop statusline / function key set */
   /* to mimic the BBS software of their choice.                         */
   od_control.od_mps = INCLUDE_MPS;

   /* Include the OpenDoors log file system, which will record when the */
   /* door runs, and major activites that the user performs.            */
   od_control.od_logfile = INCLUDE_LOGFILE;

   /* Set filename for log file. If not set, DOOR.LOG will be used by */
   /* default.                                                        */
   strcpy(od_control.od_logfile_name, "SDL.LOG");

   /* Set function to be called before program exits. */
   od_control.od_before_exit = BeforeExitFunction;

   /* Initialize OpenDoors. This function call is optional, and can be used */
   /* to force OpenDoors to read the door informtion file and begin door    */
   /* operations. If a call to od_init() is not included in your program,   */
   /* OpenDoors initialization will be performed at the time of your first  */
   /* call to any OpenDoors function. */
   od_init();

strncpy(door_sys_name,od_control.user_name,sizeof(od_control.user_name));
door();      //main part of the IGM
return 0;
}


void door(void)         ////////YOUR IGM HERE///////////
{
r_player_file();   //read the player file, make sure they are there.
if(playerfound==1)     //when it's found do the IGM
{
indelgos_bm();      //run the IGM  (originally Indelgo's Black Market)
update_player_file();     //save the changes made, if any.
}
else
	{
	od_printf("\n\rPlayer not found!");  //bad error!
	od_printf("Name Error.");
	WaitForEnter();
	}
}



void indelgos_bm(void)
{
char numstr[10];
unsigned long total=0;
unsigned long amt;
unsigned long cost;
char choice,choice2;
do{
od_clr_scr();
od_printf("͸\n\r");
od_printf("`green`STARDOCK LOCO -`cyan` Guido's Black Market                         \n\r");
od_printf(";\n\r");
od_printf("Looking furtively around you to make sure no one sees you, \n\r");
od_printf("you slip into a small room behind Guido's Bank. \n\r");
od_printf("             <`bright cyan`B`cyan`> Buy droids\n\r");
od_printf("             <`bright cyan`U`cyan`> Upgrade armor\n\r");
od_printf("             <`bright cyan`I`cyan`> Increase weapon strength\n\r");
od_printf("             <`bright cyan`X`cyan`> Exit");
sprintf(number,"%ld",current.credits); //copy the credits amount
change();                              //format it
od_printf("\n\rYour Credits: $`green`%s`cyan`.",number);    //print it
od_printf("\n\rMake your choice: ");
choice=od_get_answer("BUIX\n\r");    //get the correct key
switch(choice)
	{
	case 'B':
		amt=current.level*100000;
		sprintf(number,"%ld",amt);
		change();
		od_printf("\n\rAh, you'd like some `white`droids`cyan`, eh?  They are $`green`%s`cyan` apiece.",number);
		total=current.credits/amt;
		sprintf(number,"%ld",total);
		change();
		od_printf("\n\rYou can buy `bright cyan`%s`cyan` with your credits.",number);
		od_printf("\n\r`bright cyan`How many would you like? `cyan`[0 to exit] ");
		od_input_str(numstr,4,'0','9');
		amt=atoi(numstr);
		if(amt>0)
			{
			cost=amt*(current.level*100000);
			if(cost>current.credits)
				od_printf("`yellow`\n\rYou haven't enough money..`cyan`");
			else
				{
				sprintf(number,"%ld",amt);
				change();
				od_printf("\n\rOk, you've bought `green`%s`cyan` droids.",number);
				od_printf("\n\rI hope you use them `red`wisely`cyan`...");
				current.credits-=cost;
				current.droids+=amt;
				}
			}
			WaitForEnter();
			break;
		case 'U':
			if(current.armor_strength<350000)
				{
				od_printf("\n\rUpgrade that armor?  `bright cyan`NEVER!`cyan`");
				od_printf("\n\rGive me something to work with here!!!");
				}
			else
			{
			od_printf("\n\rIt costs $`bright cyan`100,000,000`cyan` to upgrade your armor");
			sprintf(number,"%ld",current.armor_strength);
			change();
			od_printf("\n\rfrom `bright cyan`%s`cyan` to ",number);
			sprintf(number,"%ld",(current.armor_strength+50000));
			change();
			od_printf("`bright cyan`%s`cyan`.",number);
			od_printf("\n\r`bright cyan`Do you wish to upgrade your armor? [Y/N]`cyan`");
			choice2=od_get_answer("YN\n\r");
			switch(choice2)
				{
				case 'N':
					break;
				case 'Y':
				default:
					if(current.armor_strength<2000000000)//<-this has changed.  Heck if I remember. <G>
						{
						if(current.credits>=100000000)
							{
							current.credits-=100000000;
							current.armor_strength+=50000;
							sprintf(number,"%ld",current.armor_strength);
							change();
							od_printf("\n\rOk, your armor has been upgraded to `bright cyan`%s!`cyan`",number);
							}
						else
							od_printf("\n\rYou don't have enough money!");
						}
					else
						od_printf("\n\rSorry, your armor is MAXED!!!!");

				  }
			}
		WaitForEnter();
		break;
		case 'I':
			if(current.weapon_strength<1000) //<-this may be different now.
				od_printf("\n\rWe only upgrade `bright cyan`Crowley's Cannons`cyan` or better here!");
			else
			{
			od_printf("\n\rI'll give you a great deal on an `bright cyan`O.S.S.C Overcharge Pack!`cyan`");
			od_printf("\n\rOnly cost you $`bright cyan`100,000,000`cyan` for an increase from `bright cyan`%d`cyan` to `bright cyan`%d`cyan`!",current.weapon_strength,current.weapon_strength+3);
			od_printf("\n\r`bright cyan`Do you wish to buy one? [Y/N]`cyan` ");
			choice2=od_get_answer("YN\n\r");
			switch(choice2)
				{
				case 'N':
					break;
				case 'Y':
				default:
					if(current.weapon_strength<125)
						{
						if(current.credits>=100000000)
							{
							od_printf("\n\rOk, your `bright cyan`%s`cyan` has been upgraded!",current.weapon);
							current.credits-=100000000;
							current.weapon_strength+=3;
							}
						else
							od_printf("\n\rYou don't have enough money!");
						}
					else
						od_printf("\n\rSorry, your weapon is MAXED!!!!");
				}
			}
		WaitForEnter();
		break;
		case 'X':
		default:
			choice='X';
			break;
		}
}while(choice!='X');
}


void r_player_file(void)        //initial read of the player file
{                               //see sd_devlp.txt for more info.
int k;

struct player *names;
int p=0;
FILE *fptr;
record_count=0;
if((names=(struct player*) calloc(100,sizeof(struct player)))==NULL)
	{
	od_printf("\n\rNot enough memory for Player.lst");
	WaitForEnter();
	}
else
{
	fptr = OpenExclusiveFile("player.lst", "rb", WAIT_FOR_FILE);
	while( fread(&names[record_count],sizeof(names[record_count]),1,fptr)==1)
		record_count++;
	   fclose(fptr);
	   }

		       //check for a match of name[p].bbs_name
		      //against door_sys_name
for(p=0;p<record_count;p++)
	{ //begin for
	od_kernal();  //run kernal to keep contact with remote user
	if (stricmp (door_sys_name,names[p].bbs_name) ==0)
		{  //begin if
		playerfound=1;     //player is found...
		strcpy(current.name,names[p].name);
		strcpy(current.bbs_name,names[p].bbs_name);
		current.living=atoi(names[p].living);
		strcpy(current.killer,names[p].killer);
		current.location=atoi(names[p].location);
		current.lifepoints=atol(names[p].lifepoints);
		current.lifepointsttl=atol(names[p].lifepointsttl);

		strcpy(current.weapon,names[p].weapon);
		current.weapon_energy=atol(names[p].weapon_energy);
		current.weapon_strength=atoi(names[p].weapon_strength);
		current.max_packs=atol(names[p].max_packs);

		current.weapon_status=atoi(names[p].weapon_status);
		current.weapon_cost=atol(names[p].weapon_cost);

		strcpy(current.armor,names[p].armor);
		current.armor_strength=atol(names[p].armor_strength);
		current.armor_status=atoi(names[p].armor_status);
		current.armor_cost=atol(names[p].armor_cost);

		current.credits=atol(names[p].credits);
		current.bank_credit=atol(names[p].bank_credit);

		current.pod=atoi(names[p].pod);

		current.ship=atoi(names[p].ship);
		strcpy(current.ship_name,names[p].ship_name);
		current.ship_type=atoi(names[p].ship_type);
		current.mt=atoi(names[p].mt);
		current.arkon_bomb=atoi(names[p].arkon_bomb);

		current.level=atoi(names[p].level);
		current.kills=atoi(names[p].kills);
		current.experience=atol(names[p].experience);
		current.droids=atoi(names[p].droids);
		current.passkey=atoi(names[p].passkey);

		current.on_off=atoi(names[p].on_off);
		current.sickbay_closed=atoi(names[p].sickbay_closed);
		current.bank_closed=atoi(names[p].bank_closed);
		current.pickpocket=atoi(names[p].pickpocket);
		current.tipcnt=atoi(names[p].tipcnt);
		current.owns=atoi(names[p].owns);
		current.fights=atoi(names[p].fights);
		current.last_played=atoi(names[p].last_played);

		p=record_count;
		}    //end if
	 else playerfound=0;
	}  //end for
free(names);
}

void update_player_file(void) //update the changes to the file.
{
int p=0;


struct player *names;

FILE *fptr;
if((names=(struct player*) calloc(100,sizeof(struct player)))==NULL)
	{
	od_printf("\n\rNot enough memory for player.lst");
	WaitForEnter();
	}
else
{
			   //READ player file
	fptr = OpenExclusiveFile("player.lst", "rb", WAIT_FOR_FILE);
	while( fread(&names[p],sizeof(names[p]),1,fptr)==1)
	     {
	      od_kernal();
	      if (stricmp (names[p].bbs_name,current.bbs_name) ==0)
		{
		    //when found copy data to text file
	      sprintf(names[p].on_now, "%d",current.on_now);
	      strncpy(names[p].name,current.name,sizeof(current.name));
	      strncpy(names[p].bbs_name,current.bbs_name,sizeof(current.bbs_name));
	      sprintf(names[p].living, "%d", current.living);
	      strncpy(names[p].killer,current.killer,sizeof(current.killer));
	      sprintf(names[p].location, "%d",current.location);
	      sprintf(names[p].lifepoints, "%ld", current.lifepoints);
	      sprintf(names[p].lifepointsttl, "%ld", current.lifepointsttl);

	      strncpy(names[p].weapon,current.weapon,sizeof(current.weapon));
	      sprintf(names[p].weapon_energy, "%ld", current.weapon_energy);
	      sprintf(names[p].weapon_strength, "%d", current.weapon_strength);
	      sprintf(names[p].max_packs, "%ld", current.max_packs);

	      sprintf(names[p].weapon_status, "%d", current.weapon_status);
	      sprintf(names[p].weapon_cost, "%ld", current.weapon_cost);

	      strncpy(names[p].armor,current.armor,sizeof(current.armor));
	      sprintf(names[p].armor_strength, "%ld", current.armor_strength);
	      sprintf(names[p].armor_status, "%d", current.armor_status);
	      sprintf(names[p].armor_cost, "%ld", current.armor_cost);

	      sprintf(names[p].credits, "%ld", current.credits);
	      sprintf(names[p].bank_credit, "%ld", current.bank_credit);

	      sprintf(names[p].pod,"%d",current.pod);

	      sprintf(names[p].ship,"%d",current.ship);
	      strncpy(names[p].ship_name,current.ship_name,sizeof(current.ship_name));
	      sprintf(names[p].ship_type,"%d",current.ship_type);
	      sprintf(names[p].mt,"%d",current.mt);
	      sprintf(names[p].arkon_bomb,"%d",current.arkon_bomb);

	      sprintf(names[p].level, "%d", current.level);
	      sprintf(names[p].experience, "%ld", current.experience);
	      sprintf(names[p].kills, "%d", current.kills);
	      sprintf(names[p].droids, "%d", current.droids);
	      sprintf(names[p].passkey, "%d", current.passkey);

	      sprintf(names[p].on_off,"%d",current.on_off);
	      sprintf(names[p].sickbay_closed,"%d",current.sickbay_closed);
	      sprintf(names[p].bank_closed,"%d",current.bank_closed);
	      sprintf(names[p].pickpocket,"%d",current.pickpocket);
	      sprintf(names[p].tipcnt,"%d",current.tipcnt);
	      sprintf(names[p].owns,"%d",current.owns);
	      sprintf(names[p].fights,"%d",current.fights);
	      sprintf(names[p].last_played,"%d",current.last_played);
	      }
		p++;
	     }
	   fclose(fptr);


		//write the file
	fptr = OpenExclusiveFile("player.lst", "wb", WAIT_FOR_FILE);
	fwrite(names,sizeof(struct player), p, fptr);
	fclose(fptr);
free(names);
}
}
	//exclusive file access routine by Brian Pirie, Opendoors 5.0
	//Get his stuff, it's good!  Register it as well.
FILE *OpenExclusiveFile(char *pszFileName, char *pszAccess, time_t Wait)
{
   FILE *pfFile;
   time_t StartTime = time(NULL);

   for(;;)
   {
      /* Attempt to open file */
      pfFile = fopen(pszFileName, pszAccess);

      /* If file was opened successfuly, then exit */
      if(pfFile != NULL) break;

      /* If open failed, but not due to access failure, then exit */
      if(errno != EACCES) break;

      /* If maximum time has elapsed, then exit */
      if(StartTime + Wait < time(NULL)) break;

      /* Give the OpenDoors kernel a chance to execute before trying again */
      od_kernel();
   }

   /* Return pointer to file, if opened */
   return(pfFile);
}

void WaitForEnter(void)
{
   od_printf("\n\r\n\r");  //display prompt
   od_printf("`cyan`Press `green`[ENTER]`cyan` to continue.\n\r");
   od_get_answer("\n\r");  //get a line feed or carriage return
}

void More(void)
{
   od_printf("\n\r\n\r");
   od_printf("`cyan`<ENTER>`cyan`\n\r");
   od_get_answer("\n\r");
}

void change(void)  //convert the character string to a formatted char string.
{
switch(strlen(number))
	{        //it's ooooogly, but it works.  I'm sure there is a routine
	case 0:  //built for this, but I couldn't find it.  Use it if you like.
		 //I left it with the 00 for 0 amounts.  So what!  <G>
		 //heck, I wish I would've learned pointers before doing this
		 //but, oh well.  Why change it now?  I got other things to do,
		 //like write comments all over the place, and really mess it up.
		number[0]='\x0';
	case 1:
		number[1]='0';
	case 2:
		number[2]='\x0';
	case 3:
		sprintf(number,"%c%c%c",number[0],number[1],number[2]);
		break;
	case 4:
		sprintf(number,"%c,%c%c%c",number[0],number[1],number[2],number[3]);
		break;
	case 5:
		sprintf(number,"%c%c,%c%c%c",number[0],number[1],number[2],number[3],number[4]);
		break;
	case 6:
		sprintf(number,"%c%c%c,%c%c%c",number[0],number[1],number[2],number[3],number[4],number[5]);
		break;
	case 7:
		sprintf(number,"%c,%c%c%c,%c%c%c",number[0],number[1],number[2],number[3],number[4],number[5],number[6]);
		break;
	case 8:
		sprintf(number,"%c%c,%c%c%c,%c%c%c",number[0],number[1],number[2],number[3],number[4],number[5],number[6],number[7]);
		break;
	case 9:
		sprintf(number,"%c%c%c,%c%c%c,%c%c%c",number[0],number[1],number[2],number[3],number[4],number[5],number[6],number[7],number[8]);
		break;
	case 10:
		sprintf(number,"%c,%c%c%c,%c%c%c,%c%c%c",number[0],number[1],number[2],number[3],number[4],number[5],number[6],number[7],number[8],number[9]);
		break;
	default:
		sprintf(number,"%c%c%c,%c%c%c,%c%c%c,%c%c%c",number[0],number[1],number[2],number[3],number[4],number[5],number[6],number[7],number[8],number[9],number[10],number[11]);
		break;
	}

}

