#include "defines.h"

struct IniFile {
	BOOL Initialized;

	char *pszLanguage;
	char *pszNPCFileName[MAX_NPCFILES];
	char *pszSpells[MAX_SPELLFILES];
	char *pszItems[MAX_ITEMFILES];
	char *pszRaces[MAX_RACEFILES];
	char *pszClasses[MAX_CLASSFILES];
	char *pszVillages[MAX_VILLFILES];
};


struct config {

  char szSysopName[40];
  char szBBSName[40];

  char szScoreFile[2][40];        // 0 == ascii, 1 == ansi
  char szRegcode[25];

  /*
   * IBBS Specific data
   */
  int BBSID;
  BOOL InterBBS;
  char szNetmailDir[30];
  char szInboundDir[30];
  int MailerType;
};

struct system {
  BOOL Initialized;

  char szTodaysDate[11];
  char szMainDir[40];

  int Node;
  BOOL InterBBS;
  BOOL Local;
  BOOL LocalIBBS;
};

struct PClass {
	char szName[15];
	char Attributes[NUM_ATTRIBUTES];
	int MaxHP, Gold;
  int MaxSP;
  char SpellsKnown[MAX_SPELLS];

	int VillageType;		// which villages is this allowed in?  0 == ALL
};

struct Strategy {
	char AttackLength, AttackIntensity, LootLevel;
	char DefendLength, DefendIntensity;

	/*

-		*Length = 1..10 <- how long battle is

		ex:
		if AttackLength = 10 and defender's defendlength = 2,

		NumRounds = (10 + 2) / 2 = 6;

-		*Type	   =	Light		-- small attacks, less vulnerable
						Moderate	-- moderate attacks on all grounds, medium
						Heavy		-- heavy attacks, more vulnerable

-		LootLevel = How much you will loot or attempt to loot in percentage

			allowable levels:	10% - low
								20% - moderate
								30% - high

	*/
};


struct Army {
	long Footmen, Axemen, Knights, Followers;
	char Rating;						// 0-100%, 100% = strongest
	char Level; 						// useable later?

	struct Strategy Strategy;

	long CRC;
};

struct empire {
	char szName[25];				// who's empire
	int OwnerType;					// what type of empire? clan, alliance, vill
	long VaultGold;
	int Land;						// amount of land available for use
	int Buildings[MAX_BUILDINGS];	// # of each building type
	int AllianceID;
	char WorkerEnergy;				// energy left for builders in %'age
	int LandDevelopedToday; 		// how much development we did
	int SpiesToday; 				// how many spying attempts today?
	int AttacksToday;
	long Points;					// used in future?
	int Junk[4];

	// other stuff goes here
	struct Army Army;

	long CRC;
};



struct village {
  BOOL Initialized;

  struct village_data {
    char ColorScheme[50];
    char szName[30];

    int TownType;
    int TaxRate, InterestRate, GST;
    int ConscriptionRate;

    int RulingClanId[2];
    char szRulingClan[25];
    int GovtSystem;
    int RulingDays;

    unsigned int PublicMsgIndex;

    int MarketLevel;
    int TrainingHallLevel;  /* how good is the training hall? */
    int ChurchLevel;    /* how good is the church */
    int PawnLevel;      // level of pawn shop
    int WizardLevel;    // wizard's shop level

    unsigned int
       SetTaxToday     : 1,
       SetInterestToday: 1,
       SetGSTToday     : 1,
       UpMarketToday   : 1,
       UpTHallToday    : 1,
       UpChurchToday   : 1,
       UpPawnToday     : 1,
       UpWizToday      : 1,
       SetConToday     : 1,
       ShowEmpireStats : 1,
       Junk            : 6;

    char HFlags[8];         /* daily flags -- reset nightly */
    char GFlags[8];         /* global flags -- reset with reset */

    int VillageType;    // what type of village do we have here?

    int CostFluctuation;  // from -10% to +10%
    int MarketQuality;

    struct empire Empire;

    long CRC;                 // used to prevent cheating
  } *Data;
};

struct game {
  BOOL Initialized;

  struct game_data {
    int GameState;            // 0 == Game is in progress
                              // 1 == Game is waiting for day to come to play
                              // 2 == Game is inactive, waiting for reset msg.
                              //      from LC

    BOOL InterBBS;            // set to TRUE if IBBS *originally*
                              // check when entering game against
                              // Config->InterBBS to see if cheating occurs

    char szTodaysDate[11];    // Set to today's date when maintenance run
    char szDateGameStart[11]; // First day new game begins
    char szLastJoinDate[11];  // Last day to join game

    int NextClanID;           // contains next available clanid[1] value
    int NextAllianceID;       // contains next available alliance ID


    // ---- league specific data, not used in local games
    char szWorldName[30];     // league's world name
    char LeagueID[3];         // 2 char league ID
    char GameID[16];          // used to differentiate from old league games
    BOOL ClanTravel;          // TRUE if clans are allowed to travel
    int LostDays;             // # of days before lost packets are returned
    // ----

    // ---- Individual game settings go here
    int MaxPermanentMembers;  // up to 6
    BOOL ClanEmpires;         // toggles whether clans can create empires
    int MineFights,           // Max # of mine fights per day
        ClanFights,           // max # of clan fights per day
        DaysOfProtection;     // # of days of protection for newbies

    long CRC;                 // used to prevent cheating

  } *Data;
};

struct SpellsInEffect {
	int SpellNum;	/* set to -1 so that it's inactive */
	int Energy; 	/* how much energy of spell remains, sees if it runs out */
};

struct item_data {
	BOOL Available;
	int UsedBy; 	/* 0 means nobody, 1.. etc. gives num of who uses it +1 */
	char szName[25];
	char cType;
	BOOL Special;	/* if special item, can't be bought or sold */
	int SpellNum;	// which spell do you cast when reading this scroll?

	char Attributes[NUM_ATTRIBUTES];
	char ReqAttributes[NUM_ATTRIBUTES];

	long int lCost;
	BOOL DiffMaterials; 	/* means it can be made with different matterials */
	int Energy; 			/* how long before it "breaks"? */
	int MarketLevel;		// what level of market before this is seen?

	int VillageType;		// which villages is this allowed in?  0 == ALL
	long ItemDate;			// when was item taken into the pawn shop?
	char RandLevel; 		// from 0 - 10, level of randomness, 10 is highest
	char HPAdd, SPAdd;
};


struct pc {
	char szName[20];
	int HP, MaxHP;
  int SP, MaxSP;

	char Attributes[NUM_ATTRIBUTES];
	char Status;

	int Weapon, Shield, Armor;

	int WhichRace, WhichClass;
	long Experience;
	int Level;
	int TrainingPoints;

  struct clan *MyClan;  /* pointer to his clan */
  char SpellsKnown[MAX_SPELLS];

  struct SpellsInEffect SpellsInEffect[10]; /* 10 spells is sufficient */


	int Difficulty; 		/* used only by monsters */
  char Undead : 1,
		 DefaultAction : 7; 	  // default action:
							//
							// 0 == attack
							// 1 == skip it, do nothing
							// 10 == spell #0
							// 11 == spell #1
							// 1x == spell #x

	long CRC;
};

struct clan {
  int ClanID[2];
  char szUserName[30];
  char szName[25];
  char Symbol[21];

  char QuestsDone[8], QuestsKnown[8];

  char PFlags[8], DFlags[8];
  char ChatsToday, TradesToday;

	int ClanRulerVote[2];		// who are you voting for as the ruler?

	int Alliances[MAX_ALLIES];		// alliances change from BBS to BBS, -1
                                // means no alliance, 0 = first one, ID
                                // that is...

  long Points;
  char szDateOfLastGame[11];

  int FightsLeft, ClanFights,
      MineLevel;

  int WorldStatus, DestinationBBS;

	char VaultWithdrawals;

  int PublicMsgIndex;

	int ClanCombatToday[MAX_CLANCOMBAT][2];
  int ClanWars;

  struct pc *Member[MAX_MEMBERS];
  struct item_data Items[MAX_ITEMS_HELD];

	char ResUncToday, ResDeadToday ;

  struct empire Empire;

  // Help
  BOOL DefActionHelp : 1,
       CommHelp      : 1,
       MineHelp      : 1,
       MineLevelHelp : 1,
       CombatHelp    : 1,
       TrainHelp     : 1,
       MarketHelp    : 1,
       PawnHelp      : 1,
       WizardHelp    : 1,
       EmpireHelp    : 1,
       DevelopHelp   : 1,
       TownHallHelp  : 1,
       DestroyHelp   : 1,
       ChurchHelp    : 1,
       THallHelp     : 1,
       SpyHelp       : 1,
       AllyHelp      : 1,
       WarHelp       : 1,
       VoteHelp      : 1,
       TravelHelp    : 1,

       WasRulerToday : 1,
       MadeAlliance  : 1,
       Protection    : 4,
       FirstDay      : 1,
       Eliminated    : 1,
       QuestToday    : 1,
       AttendedMass  : 1,
       GotBlessing   : 1,
       Prayed        : 1;

  long CRC;
};

struct Spell {
	char szName[20];
	int TypeFlag;
	BOOL Friendly, Target;
	char Attributes[NUM_ATTRIBUTES];
	char Value;
	int Energy;
	char Level; 	/* used to see if affects target */
	char *pszDamageStr, *pszHealStr, *pszModifyStr, *pszWearoffStr, *pszStatusStr, *pszOtherStr;
	char *pszUndeadName;
  int SP;
	BOOL StrengthCanReduce;
	BOOL WisdomCanReduce;
	int MultiAffect : 1,	// set to true if it affects more than one user
      Garbage : 7;
};


struct Language {
	char Signature[30]; 		// "The Clans Language File v1.0"

	unsigned StrOffsets[2000];		// offsets for up to 1100 strings
	unsigned NumBytes;				// how big is the bigstring!?

	char *BigString;		// All 500 strings jumbled together into
								// one
};

struct BuildingType {
	char szName[30];
	char HitZones,			// how vulnerable is it?  Higher = more vulnerable
		 LandUsed,			// how many units of land used?
		 EnergyUsed;		// how much energy is used to build it? 100=highest
	long Cost;				// how much it'll cost ya to build this

	/* in future:

	BOOL MultipleBuild; 	// FALSE == can only build one at a time
	BOOL BuildingPrerequisites[MAX_BUILDINGS];	// ???
	*/

};


struct Alliance {
	int ID;
	char szName[30];
	int CreatorID[2];
	int OriginalCreatorID[2];
	int Member[MAX_ALLIANCEMEMBERS][2];

  struct empire Empire;
  struct item_data Items[MAX_ALLIANCEITEMS];
};




// This struct should have just about EVERYTHING on the battle
// who the attacker is, what his name is, what type of attacker, what his ID is
// who the victim is, what type he is and his ID
struct AttackResult {
	BOOL Success;					// was the attacker successful?
	BOOL NoTarget;					// set this if there was no ruler to oust
									// or no clan to battle
	BOOL InterBBS;					// was this an InterBBS attack?

	// starting info
	struct Army OrigAttackArmy; 	// what troops he had originally
	int AttackerType;				// what type of attacker he is
	int AttackerID[2];				// ID of person doing the attacking
	int AllianceID; 				// ID of alliance
	char szAttackerName[25];		// name of attacker

	// set beforehand
	int DefenderType;				// what type of defender
	int DefenderID[2];				// who is being attacked?

	// set in InterBBS only
	char szDefenderName[25];

	int BBSIDFrom;					// which BBS was the attacker from?
	int BBSIDTo;					// which BBS was the attack for?

	// actual result of battle:
	int PercentDamage;
	int Goal;						// original goal of attack
	int ExtentOfAttack;
	struct Army AttackCasualties, DefendCasualties;
	int BuildingsDestroyed[MAX_BUILDINGS];
	long GoldStolen;
	int LandStolen;

	struct Army ReturningArmy;		// how many survived and are coming back?
									// only used for IBBS
	int ResultIndex;				// used to prevent cheating
	int AttackIndex;				// used to delete attackpacket from backup.dat

	long CRC;						// IBBS only
};


struct Topic {
	BOOL Known; 				/* topic known yet? */
	BOOL Active;				/* does topic even exist? */
	BOOL ClanInfo;				/* if set to TRUE, means gives info on clan
								   he is in */
	char szName[70];			/* name of topic as seen by user */
	char szFileName[25];		/* name of topic in file */
};


struct NPCInfo {
	char szName[20];
	struct Topic Topics[MAX_TOPICS];
	struct Topic IntroTopic;
  BOOL Garbage;
  int Garbage2[2];
	char Loyalty;		/* how loyal is he? */
	int WhereWander;	// where does he wander most often?
  int Garbage3;
	BOOL Roamer;		// is he a roamer type?
	int NPCPCIndex; 	// which NPC is he in the NPC.PC file?
	int KnownTopics;	// how many topics does he know?
	int MaxTopics;		// how many topics we can discuss in one sitting
	int OddsOfSeeing;	// good chance of seeing him or not
	char szHereNews[70]; // news shown when guy shows up
	// new additions
	char szQuoteFile[13];	// what file to use for quotes?
	char szMonFile[13]; 	// which .MON file is he in?
	char szIndex[20];		// index of this NPC

	int VillageType;		// which villages is this allowed in?  0 == ALL
};


struct NPCNdx {
	char szIndex[20];
	BOOL InClan;		/* in a clan yet? */
	int ClanID[2];		/* if so, which clan? */
  int WhereWander;    // where/what is he now?
  int Status;         // where/what is he now?
};


struct TradeList {
	long int Gold;
	long int Followers;
	long int Footmen, Axemen, Knights, Catapults;
};

struct TradeData {
	struct TradeList Giving;
	struct TradeList Asking;
	BOOL Active;

  int FromClanID[2], ToClanID[2];
	char szFromClan[25];
	long Code;
};


struct Message {
  int ToClanID[2], FromClanID[2];
  char szFromName[25], szDate[11],
       szAllyName[30], szFromVillageName[40];

  int MessageType;                  // 0 == Public
                                    // 1 == Private
                                    // 2 == Alliance only
  int AllianceID;                   // If MessageType == 2, this alliance
                                    //    receives the message
  int Flags;
  int BBSIDFrom, BBSIDTo;

  int PublicMsgIndex;               // Msg# for public posts

  struct Msg_Txt {
    int Offsets[40];
    int Length, NumLines;
    char *MsgTxt;
  } Data;
};


struct Packet {
  BOOL Active;

  char GameID[16];
  char szDate[11];
  int BBSIDFrom, BBSIDTo;

	int PacketType;
  long PacketLength;
};


struct AttackPacket {
	int BBSFromID;			// from whence it came
	int BBSToID;			// where it's going
  struct empire AttackingEmpire;
	struct Army AttackingArmy;	// army doing the attacking
	int Goal;				// what is the goal of this attack?
	int ExtentOfAttack; 	// level of attack
	int TargetType; 		// needed to find out who he's attacking
	int ClanID[2];			// if a clan he's attacking, this is its ID
	int AttackOriginatorID[2];	  // clanid of who started the attack

	int AttackIndex;
	long CRC;
};

struct SpyAttemptPacket {
	char szSpierName[40];
	int IntelligenceLevel;
	int TargetType; 		// either a village or clan
	int ClanID[2];			// who is the target
	int MasterID[2];		// who sent it?

	int BBSFromID;
	int BBSToID;
};

struct SpyResultPacket {
	int BBSFromID;			// these are the same as spyattemptpacket
	int BBSToID;
	int MasterID[2];		// who sent it originally?
	char szTargetName[35];	// who we're spying on

	BOOL Success;
  struct empire Empire;   // unused if unsuccessful
	char szTheDate[11];
};

struct ibbs {
  BOOL Initialized;

  struct ibbs_data {
    int BBSID;

    int NumNodes;

    // Note, use IBBS.Nodes[x] where x corresponds to the BBSID
    struct ibbs_node {
      BOOL Active;

      struct ibbs_node_info {
        char *pszBBSName;
        char *pszVillageName;
        char *pszAddress;
        int RouteThrough;
        int MailType;
      } Info;

      struct ibbs_node_reset {
        int Received;           /* used only by main BBS */
        long LastSent;          /* last attempt at sending a reset command */
      } Reset;

      struct ibbs_node_recon {
        long LastReceived;      /* when last recon gotten was */
        long LastSent;          /* last attempted recon */
        char PacketIndex;
      } Recon;

      struct ibbs_node_attack {
        int ReceiveIndex;
        int SendIndex;
      } Attack;

    } Nodes[MAX_IBBSNODES];

  } *Data;
};

struct ResetData {
  char GameID[16];
  char szDateGameStart[11];
  char szLastJoinDate[11];
	char szVillageName[40];
	BOOL InterBBSGame;
	BOOL LeagueWide;
	BOOL InProgress;
	BOOL EliminationMode;

	BOOL ClanTravel;
	int LostDays;
	BOOL ClanEmpires;
	int MineFights, ClanFights;
	int MaxPermanentMembers;		// up to 6
	int DaysOfProtection;
};

struct UserInfo {
	int ClanID[2];
	BOOL Deleted;					// set for deletion during maintenance
	char szMasterName[30];			// name of user who plays
	char szName[30];				// name of clan itself
};

struct UserScore {
	int ClanID[2];
	char Symbol[21];
	char szName[30];
	long Points;
	int BBSID;
};

struct LeavingData {
	BOOL Active;
  int DestID;
	int ClanID[2];

	// how many troops to bring along with you
	long Followers, Footmen, Axemen, Knights, Catapults;
};

