# Template for .R (room) file
#
# -----------------------------------------------------------------------------
#
#
# note: when done, make it so if user drops his crystal, he loses hp in toxic
# water!

Name            Lobby
North           Front.Cave
# Flags limit what happens in this room.
Flags           FI
Description
|13The Lobby
  |09You're in a strange circular building.  The walls are covered with
stone bricks and to the north, you can see a |05red pulsating light.
~
Script
 wait 50
 out |11Please walk north to step through the portal and be transported to%Nthe entrance of the Demon's Lair.
 wait 90
 out |06Simply type |12NORTH |06to begin!
~

Name            Coffin
# Flags limit what happens in this room.
Flags           FI
Description
|12A Coffin
  |04You're lying in a coffin.  You realize this means you have no more lives.
~
Script
:Loop
 wait 25
 out |06Please type |12QUIT |06to leave.
 wait 55
goto Loop
~

Name            Front.Cave
West            Cave.Entrance
South           Well
Description
|13In Front of a Cave
  |05You are standing in front of the cave's entrance.  It is located in the
west.  You can only see darkness within the cave from where you stand.
~

Name            Well
North           Front.Cave
Down            Down.Well
Description
|13In the Well
  |05You are standing beside an old well.  You look down the well and it looks
very deep and dark.  To the north, you see an entrance to a cave.
~

Name            Down.Well
Up              Well
Acs             HaveItem"Rope"
AcsFalseStr     |09The walls look too slippery to climb down!
AcsTrueStr      |13You tie the rope to a tree and climb down.
Description
|13In the Well
  |05You are standing at the bottom of the well.  It is very dank and cold here
and you see no other exits except up.
~

Name            Cave.Entrance
West            Cave.Door@A
East            Front.Cave
Description
|13Cave Entrance
  |05You are standing in front of the cave's entrance.  It is located in the
west.  You can only see darkness within the cave from where you stand.%N
{OpenDoor"A"}|13You see an open passageway to the west.
{!OpenDoor"A"}|13You see an closed passageway to the west.
~

Name            Cave.Door
East            Cave.Entrance
West            Bridge
North           Bridge.Room
Description
|13Within the Cave
  |05You are standing in the cave, right in front of the entrance.  You see
a small passageway to the north.  There is a moat to the west.%N
{BridgeDown=TRUE}|14You see the bridge is down and you may cross the moat.
{BridgeDown=FALSE}|14You see that the bridge is up and you cannot cross the moat.
~

Name            Bridge
East            Cave.Door
West            Castle.Entrance
Down            Moat.UnderBridge
Acs             BridgeDown=TRUE
AcsFalseStr     |14You cannot cross if there is no bridge!
Description
|13On the Bridge
  |05You are standing on the bridge across the moat.
{!GuardDead}|13A guard blocks the path!
~

Name            Bridge.Room
South           Cave.Door
Description
|13A Small Room
  |05You are standing in a small room.  You see a lever here.%N
{BridgeDown}|14The lever has been pulled down.
{!BridgeDown}|14The lever is up.
~
Script
  if (BridgeDown = FALSE)
    wait 10
    out You decide to pull the lever.
    BridgeDown = TRUE
    wait 50
    tellall |11You hear chains moving and wood creaking!
  endif
~

Name            Castle.Entrance
East            Bridge
West            Castle.1
Acs             GuardDead
AcsFalseStr     |14You cannot pass the guard nonchalantly!!
Description
|13A Castle
  |06You are amazed.  A small castle has been built within the confines of this
cave.  The ceiling of the cave in this area is very high and looks very stable.
You can see a door into the castle to the west.  To the east, you see the
bridge over the moat.
~

Name            Castle.1
North           Castle.4
South           Castle.2
East            Castle.Entrance
Description
|13Inside the castle
  |06You are standing in a large room within the castle.  To the north, you can
see a hallway leading to a set of huge doors.  To the south, you see a
hallway.
~

Name            Castle.2
West            Castle.3@C
North           Castle.1
Description
|13A Hallway
  |06You are standing in a narrow hallway.  To the north, you can barely see
large doors.  To the west is a door.  %Z
{OpenDoor"C"}|12The door is open.
{!OpenDoor"C"}|12The door is closed.
~

Name            Castle.3
East            Castle.2
North           SecretRoom@D
Description
|13Inside a Room
  |06You are standing in a small room.  The walls are an emerald green and glisten
as the torches mounted on them flicker.  You see a door to the east. You see
a wooden door with many scratches to the north.
~
Script
:Loop
  if (!OpenDoor"D" & !ItemHere"Crystal")
    open D
    out You hear a door open!
  endif
  else
    goto Loop
  endif
~

Name            SecretRoom
South           Castle.3@D
Description
|06A Dark Room
  |02You are standing in a very dark room.  You can see several bones of humans
laid out on the ground.  There is an awful stench as well.  To the south, you
can see a green room.
~


Name            Castle.4
North           NoRoom@Z
South           Castle.1
Description
|12Huge Doors
  |04You stand before two huge doors which look to be double your height.  To
the south, you see a larger room.
~


# -----------------------------------------------------------------------------
# The Moat
# -----------------------------------------------------------------------------

Name            Moat.UnderBridge
North           Moat.North
South           Moat.South
Acs             HaveItem"Crystal" | IsDemon
AcsFalseStr     |14The water is toxic!
Domains         W
Description
|02Moat
  |09You are swimming in the moat directly beneath the bridge.  To the south, the
moat continues.  To the north, the moat continues as well but quickly turns
west.
~

Name            Moat.South
North           Moat.UnderBridge
South           Moat.MoreSouth
Acs             HaveItem"Crystal" | IsDemon
AcsFalseStr     |14The water is toxic!
Domains         W
Description
|02Moat
  |09You are swimming in the moat.  To the north and above, you can see the bridge
spanning the width of the moat.  To the south, you notice the moat shifts west.
~

Name            Moat.MoreSouth
North           Moat.South
West            Moat.SmallLanding
Acs             HaveItem"Crystal" | IsDemon
AcsFalseStr     |14The water is toxic!
Domains         W
Description
|02Moat
  |09You are swimming in the moat.  To the north you can see the moat continues
for many more feet.  You can see a small landing where one can stand to the
west.
~

Name            Moat.SmallLanding
East            Moat.MoreSouth
North           Moat.SouthRoom
Description
|02A Small Landing
  |09You are standing on a small landing a foot above the moat.  You see an
archway leading north.  You see the moat to the west.
~

Name            Moat.SouthRoom
South           Moat.SmallLanding
Description
|02A Secret Room
  |09You are standing in a room.  To the south, you can see an archway leading
to a moat.
~

Name            Moat.North
South           Moat.UnderBridge
West            Moat.DoorLanding
Acs             HaveItem"Crystal" | IsDemon
AcsFalseStr     |14The water is toxic!
Domains         W
Description
|02Moat
  |09You are swimming in the moat.  To the south and above, you can see the bridge
spanning the width of the moat.  The moat turns west and you can see a landing
and a door to the west.
~

Name            Moat.North
South           Moat.UnderBridge
West            Moat.DoorLanding
Acs             HaveItem"Crystal" | IsDemon
AcsFalseStr     |14The water is toxic!
Domains         W
Description
|02Moat
  |09You are swimming in the moat.  To the south and above, you can see the bridge
spanning the width of the moat.  The moat turns west and you can see a landing
and a door to the west.
~

Name            Moat.DoorLanding
East            Moat.North
North           WaterTrap
Domains         W
Description
|02Door Landing
  |09You are standing on a stone landing which is a few centimetres above the
water.  You see a large metal room to the north.  To the east, you can see the
moat.
~

Name            WaterTrap
Up              WaterTrap.Up
Description
|13Metal Room
  |09You are in a large metal room.  It is cylindrical and you can see several
round holes in the walls.  Above you, you can see a hole in the ceiling.
{Water=1}%N|13The water level is up to your ankles.
{Water=2}%N|13The water level is up to your knees.
{Water=3}%N|13The water level is up to your waist.
{Water=4}%N|13The water level is up to your chest.
{Water=5}%N|13The water level is up to your neck.
{Water=6}%N|13The water has filled the room and you are struggling to breathe.
~
Script
  out The door locks behind you
  wait 50
  out You hear something.
  wait 25
  out It sounds like water!
  wait 30
  out The walls begin to shake.
  wait 20
  out Water begins to seep into the room slowly.
  wait 40
  out Soon the water is moving faster and faster.
  wait 30
  out The water begins to rise to your ankles
  Water = 1
  wait 30
  out The water begins to rise to your knees.
  Water = 2
  wait 30
  out The water begins to rise to your waist.
  Water = 3
  wait 30
  out The water begins to rise to your chest.
  Water = 4
  wait 30
  out The water has risen to your neck.
  Water = 5
  wait 30
  out You struggle to remain above the water.
  Water = 6
  losehp 4

  :loop
    wait 50
    out You swallow a litre of water.
    losehp 2
  goto loop
~

Name            WaterTrap.Up
Acs             Water = 6
AcsFalseStr     |14It's too high to reach from here!
North           Tunnel.1
Description
|12A Tunnel
  |06You are in a small tunnel created by burrowing through the rock in this
cave.  You see a light to the north.  Down below, you can see a water filled
room.
~

Name            Tunnel.1
North           Tunnel.2
East            Tunnel.Red
West            Tunnel.Green
Description
|12A Tunnel
  |06You are in a small tunnel.  To the east, you see a |12red |06tunnel and to the
west is a |02green |06tunnel.
~

Name            Tunnel.2
South           Tunnel.1
North           Tunnel.Door@EF
Description
|12A Tunnel
  |06You see a small shrine with two candles surrounding it.  There is a picture
on the wall between the two candles.  An evil looking man is pictured in the
image.
~

Name            Tunnel.Red
West            Tunnel.1
Description
|12A Red Tunnel
  |04You are standing in a red tunnel.  To the west, you see more tunnel.
~
Script
:Loop
 if (ItemHere"red" & !OpenDoor"E")
   open E

   if (OpenDoor"EF")
     out You hear a door open!
   endif
   else
     out You hear metal creaking!
   endif
 endif
 else
   goto Loop
 endif
~

Name            Tunnel.Green
East            Tunnel.1
Description
|10A Green Tunnel
  |02You are standing in a green tunnel.  To the east, you see more tunnel.
~
Script
:Loop
 if (ItemHere"green" & !OpenDoor"F")
   open F

   if (OpenDoor"EF")
     out You hear a door open!
   endif
   else
     out You hear metal creaking!
   endif
 endif
 else
   goto Loop
 endif
~

Name            Tunnel.Door
South           Tunnel.2
Down            Lair.1
Description
|12A View of the Court
  |02From here, you can see the Demon Lord's court.  You see that you can jump
down to the ground below without any injury, but you will not be able to get
back up.  To the south, you can see a tunnel.
~

Name            Lair.1
North           Lair.2
Description
|13Within the Court
  |09Your are standing within the Demon Lord's court.  To the north, you see
black carpeting leading to the Demon Lord's throne.
~

Name            Lair.2
South           Lair.1
North           Lair.3
Description
|13Within the Court
  |09Your are standing within the Demon Lord's court.  The black carpeting leads
north to the throne and also south.
~

Name            Lair.3
South           Lair.2
North           Lair.4
Acs             NumDead = 2
AcsFalseStr     Finish off your current fight first!
Description
|13Before the Throne
  |09Your are standing before the Demon Lord's throne and it is double your
size.  You see black carpeting lining the ground and leading south.
~

Name            Lair.4
South           Lair.3
Description
|13Behind the Throne
  |09Your are standing behind the Demon Lord's throne.
~
